
"""
Created on Wed Aug 30 14:48:13 2023

@author: Admin
"""


from os import listdir
from os.path import isfile, join
import serial 

import numpy as np
import pandas as pd 
import time 
from scipy.integrate import trapz

#step1: be sure to the address of the files that the ftir data is exported is matching to line 11 (mypath)
mypath = "C:\\Users\\Admin\\Desktop\\ruchi\\Exp 2024-04-11 13-33"
onlyfiles = [f for f in listdir(mypath) if isfile(join(mypath, f))]


#step2: make sure that pump and the potentiostat is correctly addressed in the line 16 and 17
#pump_1 = serial.Serial("COM10",9600) #hwSyringe Pump
#pump_2 = serial.Serial("COM16",9600) #Syringe Pump
#pump_3 = serial.Serial("COM19",9600) #Syringe Pump
#pump_4 = serial.Serial("COM15",9600) #Syringe Pump
pump_5 = serial.serial_for_url("COM29",9600) #HPLC Pump 
#pump_6 = serial.serial_for_url("socket://169.254.225.18:10001",9600)
port = serial.Serial("COM1",115200)
#pump_7 = serial.Serial("COM28",9600) #HPLC Pump
pump_8 = serial.Serial("COM30",9600) #HPLC Pump
#pump_9 = serial.Serial("COM5",9600) #HPLC Pump
printer = serial.Serial("COM14", 115200, timeout=1)

r_1=14.25 #radius of syringe used (50ml,14.25|20ml,9.6|10ml,7.25|5ml,6.03|3ml,4/3|1ml,2.39|60ml,13.36)
r_2=14.25
r_3=14.25
r_4=14.25
#pump_1_k=(14.25/r_1)**2
#pump_2_k=(14.25/r_2)**2
#pump_3_k=(14.25/r_3)**2
#pump_4_k=(14.25/r_4)**2

#step 3: grab the lines from 22 to 90 and presss f9 
def area_under(data,start,end):
    x = np.flip(data.iloc[start:end,0].to_numpy())
    y = np.flip(data.iloc[start:end,1].to_numpy())
    area = trapz(y,x)
    return np.abs(area)

def file_namer(num):
    str1 = str(num)
    length = int(len((str1)))
    empt = ''
    for i in range(5-length):
        empt = empt+'0'
        
    return empt+str1

        
def ftir_extract(filename,init,end):

    filename = filename

    temp_df = pd.read_csv(filename)
    # nump_df = temp_df.to_numpy()
    area = area_under(temp_df, init, end)
    # max_peak = np.max(nump_df[90:120,1])
    print(area)

    return area


def function(flowrate_1,flowrate_2,flowrate_3,flowrate_4,flowrate_5,flowrate_6,flowrate_7,flowrate_8,flowrate_9,v,i):
    
     #set the pumps with the flowrate as the desired flowrate for the function

    #fr_1 = flowrate_1*1000*pump_1_k   #ml/min to microliter/min and syringe correction factor
    #fr_2 = flowrate_2*1000*pump_2_k   #ml/min to microliter/min and syringe correction factor
    #fr_3 = flowrate_3*1000*pump_3_k   #ml/min to microliter/min and syringe correction factor
    #fr_4 = flowrate_4*1000*pump_4_k   #ml/min to microliter/min and syringe correction factor
    time.sleep(0.1)
    fr_5 = flowrate_5*1000   #ml/min
    pump_5.write(('flow:'+ str(fr_5) + '\r').encode())
    
    #time.sleep(0.1)
    #fr_6=flowrate_6*1000 #converting ml/min to ul/min as pump takes this as input val
    #pump_6.write(('flow:'+ str(fr_6) + '\r').encode())
   
    #time.sleep(0.1)
    #fr_7 = flowrate_7*1000   #ml/min
    #pump_7.write(('flow:'+ str(fr_7) + '\r').encode())
    
    time.sleep(0.1)
    fr_8=flowrate_8*1000 #converting ml/min to ul/min as pump takes this as input val
    pump_8.write(('flow:'+ str(fr_8) + '\r').encode())
    
    #time.sleep(0.1)
    #fr_9=flowrate_9*1000 #converting ml/min to ul/min as pump takes this as input val
    #pump_9.write(('flow:'+ str(fr_9) + '\r').encode())
    #time.sleep(0.1)
    
    #set the com port for potentiostat and set the voltage and current    
    vol = v
    curr = i
    port.write(('VOLT '+str(vol)+'\r\n').encode())     #to change the voltge we need to use "VOLT 1" command 
    port.write(('CURR '+str(curr)+'\r\n').encode())    #to change the current we need to use "CURR 1" command

    
    #pumps run
    pump_5.write(b'on\r')
    time.sleep(0.1)
    #pump_6.write(b'on\r')
    #time.sleep(0.1)
    #pump_7.write(b'on\r')
    #time.sleep(0.1)
    pump_8.write(b'on\r')
    time.sleep(0.1)
    #pump_9.write(b'on\r')
    #time.sleep(0.1)
    
   
    #send_syr_command_1(f'fr{fr_1}')
    #send_syr_command_2(f'fr{fr_2}')
    #send_syr_command_3(f'fr{fr_3}')
    #send_syr_command_4(f'fr{fr_4}')
    time.sleep(15000)
def function2():
    time.sleep(15000) # Last 3 minutes
    files = [f for f in listdir(mypath) if isfile(join(mypath, f))]

    val = 0
    
    #change wavelengths as per product here.
    f_row=17 #first row of range for wavelength as per IR CSV
    l_row=24 #last row of range for wavelength as per IR CSV
    
    val += ftir_extract(files[-1],f_row,l_row)
    val += ftir_extract(files[-2],f_row,l_row)
    val += ftir_extract(files[-3],f_row,l_row)

    avg_val = val/3
    
    return avg_val


#step 4:grab the line 93 and f9
from skopt.optimizer import Optimizer

#def send_syr_command_1(command):
    #pump_1.write(command.encode() + b'\n')  # Send the command to Arduino with a newline character
    #pump_1.flush()  # Flush the serial buffer

#def send_syr_command_2(command):
    #pump_2.write(command.encode() + b'\n')  # Send the command to Arduino with a newline character
    #pump_2.flush()  # Flush the serial buffer

#def send_syr_command_3(command):
    #pump_3.write(command.encode() + b'\n')  # Send the command to Arduino with a newline character
    #pump_3.flush()  # Flush the serial buffer
#def send_syr_command_4(command):
    #pump_4.write(command.encode() + b'\n')  # Send the command to Arduino with a newline character
    #pump_4.flush()  # Flush the serial buffer
#step5:in line 96 we have to define the range that (flowrate,voltage,current) (from,to) and after (anytime) appllying changes you need to grab the line 96 and f9
#flowrates are in ml/min, voltage in V, Current in Ampere
bounds = [(-10.0,-5.0),(0.1,0.2),(0.1,0.2),(0.1,0.2),(0.012,0.013),(0.1,0.2),(0.1,0.2),(0.012,0.013),(0.1,0.2),(14.49,14.50),(4.99,5.00)]
#step 6: grab the line 100 and f9
opter =Optimizer(bounds,base_estimator='gp',n_initial_points=3,acq_func="EI",random_state=np.random.randint(3326))


#step7: to selecte number of the cycles that you have to do the experiment and then grab the line 104 to 121 and f9: the closed loop experimentation is initiated
number_of_cycles =5
results = []
#flowrates_1 = []
#flowrates_2 = []
#flowrates_3 = []
#flowrates_4 = []
flowrates_5 = []
#flowrates_6 = []
#flowrates_7 = []
flowrates_8 = []
#flowrates_9 = []
vs = []
currents = []

product_wavelength=True #set to true if product wavelengths being monitored

if product_wavelength == True:
    val=1
else:
    val=-1

# Step 8: Test Tubes on Printer
USE_PRINTER = True
REST_HEIGHT = 200
X_HOME = -5
Y_HOME = 20
Z_HOME = 175
DEFAULT_PUMP_TIME="1"
# Distance between test tubes
X_SPACING=20
Y_SPACING=20
# Number of test tubes
X_ROWS = 11
Y_COLUMNS = 4

#--------------------code for changing column for run---
column_num=5 #column number of run to try from
Y_HOME=Y_HOME+(column_num-1)*Y_SPACING
#-------------------------------------------------------

def send_cmd(cmd):
    print(cmd)
    printer.write(f"{cmd}\n".encode("ASCII"))

def move(x=None, y=None, z=None):
    s = "G0"
    if x is not None:
        s += f"X{x}"
    if y is not None:
        s += f"Y{y}"
    if z is not None:
        s += f"Z{z}"
    
    s+= "F5000"
    send_cmd(s)

def printer_positions():
    for j in range(Y_COLUMNS):
        for i in range(X_ROWS):
            if j%2==1:
                yield (X_HOME + (X_ROWS - 1 - i) * X_SPACING, Y_HOME + j * Y_SPACING, Z_HOME)
            else:
                yield (X_HOME + i * X_SPACING, Y_HOME + j * Y_SPACING, Z_HOME)

# Run this.
tube_location = list(printer_positions())

try:
    for i in range(number_of_cycles):
        move(*tube_location[2*i])
        asked = opter.ask()
        function(asked[0],asked[1],asked[2],asked[3],asked[4],asked[5],asked[6],asked[7],asked[8],asked[9],asked[10])
        move(*tube_location[2*i+1])
        told= function2()
        
        print(f"area under the curve in the round {i:.2f} = {told:.2f}")
        opter.tell(asked,-told*val)
        results.append(told)
        #flowrates_1.append(asked[0])
        #flowrates_2.append(asked[1])
        #flowrates_3.append(asked[2])
        #flowrates_4.append(asked[3])
        flowrates_5.append(asked[4])
        #flowrates_6.append(asked[5])
        #flowrates_7.append(asked[6])
        flowrates_8.append(asked[7])
        #flowrates_9.append(asked[8])
        vs.append(asked[9])
        currents.append(asked[10])
    
         #dict1 = {"flowrate_2":flowrates_2,"flowrate_3":flowrates_3,"flowrate_4":flowrates_4,"flowrate_5":flowrates_5,"flowrate_6":flowrates_6,"flowrate_7":flowrates_7,"flowrate_8":flowrates_8,"flowrate_9":flowrates_9,"voltages":vs,"currents":currents,"area-results":results}
        dict1 = {"flowrate_5":flowrates_5,"flowrate_8":flowrates_8,"voltages":vs,"currents":currents,"area-results":results}
        df2 = pd.DataFrame(dict1)
        df2.to_csv("output round "+str(i)+".csv")
finally:
    #pump_1.write(b'stop\r')        
    #pump_2.write(b'stop\r')
    #pump_3.write(b'stop\r')        
    #pump_4.write(b'stop\r')
    pump_5.write(b'off\r')        
    #pump_6.write(b'off\r')
    #pump_7.write(b'off\r')        
    pump_8.write(b'off\r')
    #pump_9.write(b'off\r')
